/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import projectvibrantjourneys.init.world.PVJBlockPlacers;

public class BaobabTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<BaobabTrunkPlacer> CODEC = RecordCodecBuilder.create(x -> BaobabTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)x).apply((Applicative)x, BaobabTrunkPlacer::new));

    public BaobabTrunkPlacer(int baseHeight, int heightA, int heightB) {
        super(baseHeight, heightA, heightB);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return PVJBlockPlacers.BAOBAB_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int height, BlockPos pos, Set<BlockPos> blocks, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        BlockPos blockpos = pos.func_177977_b();
        BaobabTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos);
        BaobabTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177974_f());
        BaobabTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177968_d());
        BaobabTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)blockpos.func_177968_d().func_177974_f());
        for (int i = 0; i < height; ++i) {
            this.placeLog(world, rand, blockpos$mutable, blocks, box, config, pos, 0, i, 0);
            this.placeLog(world, rand, blockpos$mutable, blocks, box, config, pos, 1, i, 0);
            this.placeLog(world, rand, blockpos$mutable, blocks, box, config, pos, 1, i, 1);
            this.placeLog(world, rand, blockpos$mutable, blocks, box, config, pos, 0, i, 1);
        }
        BlockPos branchStart = pos.func_177981_b(height - 2);
        this.genBranches(world, Direction.NORTH, Direction.WEST, rand, branchStart, blocks, box, config, list);
        this.genBranches(world, Direction.SOUTH, Direction.WEST, rand, branchStart.func_177968_d(), blocks, box, config, list);
        this.genBranches(world, Direction.NORTH, Direction.EAST, rand, branchStart.func_177974_f(), blocks, box, config, list);
        this.genBranches(world, Direction.SOUTH, Direction.EAST, rand, branchStart.func_177968_d().func_177974_f(), blocks, box, config, list);
        BlockPos innerLayerPos = pos.func_177970_e(2).func_177976_e();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                BlockPos p;
                int h = 4 + rand.nextInt(3);
                BlockPos tempPos = innerLayerPos.func_177964_d(x).func_177965_g(z).func_177981_b(h);
                for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
                    BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)p, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
                }
            }
        }
        this.placeRoot(world, rand, pos.func_177985_f(2), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177985_f(2).func_177968_d(), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177964_d(2), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177964_d(2).func_177974_f(), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177965_g(3), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177965_g(3).func_177968_d(), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177970_e(3), blocks, box, config);
        this.placeRoot(world, rand, pos.func_177970_e(3).func_177974_f(), blocks, box, config);
        return list;
    }

    private void placeLog(IWorldGenerationReader world, Random rand, BlockPos.Mutable pos, Set<BlockPos> blocks, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config, BlockPos start, int offX, int offY, int offZ) {
        pos.func_239621_a_((Vector3i)start, offX, offY, offZ);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)pos, blocks, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)config);
    }

    public void genBranches(IWorldGenerationReader world, Direction d1, Direction d2, Random rand, BlockPos branchStart, Set<BlockPos> blocks, MutableBoundingBox box, BaseTreeFeatureConfig config, List<FoliagePlacer.Foliage> list) {
        BlockPos temp = branchStart;
        for (int length = 0; length <= 3 + rand.nextInt(4); ++length) {
            temp = temp.func_177971_a(d1.func_176730_m());
            if (rand.nextBoolean()) {
                BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
                temp = temp.func_177971_a(d2.func_176730_m());
            }
            if ((double)rand.nextFloat() > 0.33) {
                temp = temp.func_177984_a();
            }
            BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
            if (!rand.nextBoolean()) continue;
            BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177977_b(), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        }
        temp = temp.func_177984_a();
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177976_e(), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177974_f(), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177978_c(), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177968_d(), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        temp = temp.func_177984_a();
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177985_f(2), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177965_g(2), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177964_d(2), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)temp.func_177970_e(2), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        list.add(new FoliagePlacer.Foliage(temp, 0, true));
    }

    private void placeRoot(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        BlockPos p;
        int h = 2 + rand.nextInt(3);
        BlockPos tempPos = pos.func_177981_b(h);
        for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
            BaobabTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)p, logs, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
        }
    }

    private boolean canPlaceRoot(IWorldGenerationReader world, BlockPos pos) {
        return !world.func_217375_a(pos, s -> s.func_185904_a().func_76220_a());
    }
}

